/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.factoryBoard;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.element.RenderElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.content.logistics.AddressEditBox;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelConnectionHandler;
import com.zurrtum.create.client.content.trains.station.NoShadowFontWrapper;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.box.PackageStyles;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.infrastructure.packet.c2s.FactoryPanelConfigurationPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public class FactoryPanelScreen
extends AbstractSimiScreen {
    private ElementWidget renderedBlock;
    private ElementWidget renderedItem;
    private AddressEditBox addressBox;
    private IconButton confirmButton;
    private IconButton deleteButton;
    private IconButton newInputButton;
    private IconButton relocateButton;
    private IconButton activateCraftingButton;
    private ScrollInput promiseExpiration;
    private ServerFactoryPanelBehaviour behaviour;
    private boolean restocker;
    private boolean sendReset;
    private boolean sendRedstoneReset;
    private BigItemStack outputConfig;
    private List<BigItemStack> inputConfig;
    private List<FactoryPanelConnection> connections;
    private boolean craftingActive;

    public FactoryPanelScreen(ServerFactoryPanelBehaviour behaviour) {
        this.behaviour = behaviour;
        this.restocker = behaviour.panelBE().restocker;
        this.craftingActive = !behaviour.activeCraftingArrangement.isEmpty();
        this.updateConfigs(class_310.method_1551().field_1687);
    }

    private void updateConfigs(class_638 world) {
        this.connections = new ArrayList<FactoryPanelConnection>(this.behaviour.targetedBy.values());
        this.outputConfig = new BigItemStack(this.behaviour.getFilter(), this.behaviour.recipeOutput);
        this.inputConfig = this.connections.stream().map(c -> {
            ServerFactoryPanelBehaviour b = ServerFactoryPanelBehaviour.at((class_1920)world, c.from);
            return b == null ? new BigItemStack(class_1799.field_8037, 0) : new BigItemStack(b.getFilter(), c.amount);
        }).toList();
        if (this.behaviour.craftingList == null) {
            this.craftingActive = false;
        }
    }

    @Override
    protected void method_25426() {
        int sizeX = AllGuiTextures.FACTORY_GAUGE_BOTTOM.getWidth();
        int sizeY = (this.restocker ? AllGuiTextures.FACTORY_GAUGE_RESTOCK : AllGuiTextures.FACTORY_GAUGE_RECIPE).getHeight() + AllGuiTextures.FACTORY_GAUGE_BOTTOM.getHeight();
        this.setWindowSize(sizeX, sizeY);
        super.method_25426();
        this.method_37067();
        int x = this.guiLeft;
        int y = this.guiTop;
        if (this.addressBox == null) {
            String frogAddress = this.behaviour.getFrogAddress();
            this.addressBox = new AddressEditBox(this, new NoShadowFontWrapper(this.field_22793), x + 36, y + this.windowHeight - 51, 108, 10, false, frogAddress);
            this.addressBox.method_1852(this.behaviour.recipeAddress);
            this.addressBox.method_1868(-11184811);
        }
        this.addressBox.method_46421(x + 36);
        this.addressBox.method_46419(y + this.windowHeight - 51);
        this.method_37063((class_364)this.addressBox);
        this.confirmButton = new IconButton(x + sizeX - 33, y + sizeY - 25, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.field_22787.method_1507(null));
        this.confirmButton.setToolTip((class_2561)CreateLang.translate("gui.factory_panel.save_and_close", new Object[0]).component());
        this.method_37063(this.confirmButton);
        this.deleteButton = new IconButton(x + sizeX - 55, y + sizeY - 25, AllIcons.I_TRASH);
        this.deleteButton.withCallback(() -> {
            this.sendReset = true;
            this.field_22787.method_1507(null);
        });
        this.deleteButton.setToolTip((class_2561)CreateLang.translate("gui.factory_panel.reset", new Object[0]).component());
        this.method_37063(this.deleteButton);
        this.promiseExpiration = new ScrollInput(x + 97, y + this.windowHeight - 24, 28, 16).withRange(-1, 31).titled(CreateLang.translate("gui.factory_panel.promises_expire_title", new Object[0]).component());
        this.promiseExpiration.setState(this.behaviour.promiseClearingInterval);
        this.method_37063(this.promiseExpiration);
        this.newInputButton = new IconButton(x + 31, y + 47, AllIcons.I_ADD);
        this.newInputButton.withCallback(() -> {
            FactoryPanelConnectionHandler.startConnection(this.behaviour);
            this.field_22787.method_1507(null);
        });
        this.newInputButton.setToolTip((class_2561)CreateLang.translate("gui.factory_panel.connect_input", new Object[0]).component());
        this.relocateButton = new IconButton(x + 31, y + 67, AllIcons.I_MOVE_GAUGE);
        this.relocateButton.withCallback(() -> {
            FactoryPanelConnectionHandler.startRelocating(this.behaviour);
            this.field_22787.method_1507(null);
        });
        this.relocateButton.setToolTip((class_2561)CreateLang.translate("gui.factory_panel.relocate", new Object[0]).component());
        if (!this.restocker) {
            this.method_37063(this.newInputButton);
            this.method_37063(this.relocateButton);
        }
        this.activateCraftingButton = null;
        if (this.behaviour.craftingList != null) {
            this.activateCraftingButton = new IconButton(x + 31, y + 27, AllIcons.I_3x3);
            this.activateCraftingButton.green = this.craftingActive;
            this.activateCraftingButton.withCallback(() -> {
                this.craftingActive = !this.craftingActive;
                this.clearRenderedElements();
                this.method_25426();
                if (this.craftingActive) {
                    this.outputConfig.count = this.behaviour.craftingList.getFirst().count;
                }
            });
            this.activateCraftingButton.setToolTip((class_2561)CreateLang.translate("gui.factory_panel.activate_crafting", new Object[0]).component());
            this.method_37063(this.activateCraftingButton);
        }
        int previewY = this.restocker ? 0 : 60;
        this.renderedBlock = new ElementWidget(x + 195, y + 55 + previewY).showingElement((RenderElement)GuiGameElement.of(AllItems.FACTORY_GAUGE.method_7854()).scale(4.0f));
        this.method_37063(this.renderedBlock);
        if (!this.behaviour.getFilter().method_7960()) {
            this.renderedItem = new ElementWidget(x + 214, y + 68 + previewY).showingElement((RenderElement)GuiGameElement.of(this.behaviour.getFilter()).scale(1.625f));
            this.method_37063(this.renderedItem);
        } else {
            this.renderedItem = null;
        }
    }

    private void clearRenderedElements() {
        this.renderedBlock.getRenderElement().clear();
        if (this.renderedItem != null) {
            this.renderedItem.getRenderElement().clear();
        }
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (this.inputConfig.size() != this.behaviour.targetedBy.size()) {
            this.updateConfigs(this.field_22787.field_1687);
            this.clearRenderedElements();
            this.method_25426();
        }
        if (this.activateCraftingButton != null) {
            this.activateCraftingButton.green = this.craftingActive;
        }
        this.addressBox.tick();
        this.promiseExpiration.titled(CreateLang.translate(this.promiseExpiration.getState() == -1 ? "gui.factory_panel.promises_do_not_expire" : "gui.factory_panel.promises_expire_title", new Object[0]).component());
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int state;
        AllGuiTextures bg;
        int x = this.guiLeft;
        int y = this.guiTop;
        AllGuiTextures allGuiTextures = bg = this.restocker ? AllGuiTextures.FACTORY_GAUGE_RESTOCK : AllGuiTextures.FACTORY_GAUGE_RECIPE;
        if (this.restocker) {
            AllGuiTextures.FACTORY_GAUGE_RECIPE.render(graphics, x, y - 16);
        }
        bg.render(graphics, x, y);
        AllGuiTextures.FACTORY_GAUGE_BOTTOM.render(graphics, x, y + bg.getHeight());
        y = this.guiTop;
        int slot = 0;
        if (this.craftingActive) {
            List<BigItemStack> list = this.behaviour.craftingList;
            int size = list.size();
            for (int i = 1; i < size; ++i) {
                this.renderInputItem(graphics, slot++, list.get(i), mouseX, mouseY);
            }
        } else {
            for (BigItemStack itemStack : this.inputConfig) {
                this.renderInputItem(graphics, slot++, itemStack, mouseX, mouseY);
            }
            if (this.inputConfig.isEmpty()) {
                int inputX = this.guiLeft + (this.restocker ? 88 : 68 + slot % 3 * 20);
                int inputY = this.guiTop + (this.restocker ? 12 : 28) + slot / 3 * 20;
                if (!this.restocker && mouseY > inputY && mouseY < inputY + 60 && mouseX > inputX && mouseX < inputX + 60) {
                    graphics.method_51434(this.field_22793, List.of(CreateLang.translate("gui.factory_panel.unconfigured_input", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.factory_panel.unconfigured_input_tip", new Object[0]).style(class_124.field_1080).component(), CreateLang.translate("gui.factory_panel.unconfigured_input_tip_1", new Object[0]).style(class_124.field_1080).component()), mouseX, mouseY);
                }
            }
        }
        if (this.restocker) {
            this.renderInputItem(graphics, slot, new BigItemStack(this.behaviour.getFilter(), 1), mouseX, mouseY);
        }
        if (!this.restocker) {
            int outputX = x + 160;
            int outputY = y + 48;
            graphics.method_51427(this.outputConfig.stack, outputX, outputY);
            graphics.method_51432(this.field_22793, this.behaviour.getFilter(), outputX, outputY, "" + this.outputConfig.count);
            if (mouseX >= outputX - 1 && mouseX < outputX - 1 + 18 && mouseY >= outputY - 1 && mouseY < outputY - 1 + 18) {
                class_5250 c1 = CreateLang.translate("gui.factory_panel.expected_output", CreateLang.itemName(this.outputConfig.stack).add(CreateLang.text(" x" + this.outputConfig.count)).string()).color(ScrollInput.HEADER_RGB).component();
                class_5250 c2 = CreateLang.translate("gui.factory_panel.expected_output_tip", new Object[0]).style(class_124.field_1080).component();
                class_5250 c3 = CreateLang.translate("gui.factory_panel.expected_output_tip_1", new Object[0]).style(class_124.field_1080).component();
                class_5250 c4 = CreateLang.translate("gui.factory_panel.expected_output_tip_2", new Object[0]).style(class_124.field_1063).style(class_124.field_1056).component();
                graphics.method_51434(this.field_22793, this.craftingActive ? List.of(c1, c2, c3) : List.of(c1, c2, c3, c4), mouseX, mouseY);
            }
        }
        Matrix3x2fStack ms = graphics.method_51448();
        ms.pushMatrix();
        if (this.addressBox.method_49606() && !this.addressBox.method_25370()) {
            this.showAddressBoxTooltip(graphics, mouseX, mouseY);
        }
        class_5250 title = CreateLang.translate(this.restocker ? "gui.factory_panel.title_as_restocker" : "gui.factory_panel.title_as_recipe", new Object[0]).component();
        graphics.method_51439(this.field_22793, (class_2561)title, x + 97 - this.field_22793.method_27525((class_5348)title) / 2, y + (this.restocker ? -12 : 4), -12764088, false);
        if (!this.behaviour.targetedByLinks.isEmpty()) {
            class_1799 asStack = AllItems.REDSTONE_LINK.method_7854();
            int itemX = x + 9;
            int itemY = y + this.windowHeight - 24;
            AllGuiTextures.FROGPORT_SLOT.render(graphics, itemX - 1, itemY - 1);
            graphics.method_51427(asStack, itemX, itemY);
            if (mouseX >= itemX && mouseX < itemX + 16 && mouseY >= itemY && mouseY < itemY + 16) {
                List<class_5250> linkTip = List.of(CreateLang.translate("gui.factory_panel.has_link_connections", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.factory_panel.left_click_disconnect", new Object[0]).style(class_124.field_1063).style(class_124.field_1056).component());
                graphics.method_51434(this.field_22793, linkTip, mouseX, mouseY);
            }
        }
        graphics.method_51439(this.field_22793, (class_2561)CreateLang.text((String)((state = this.promiseExpiration.getState()) == -1 ? " /" : (state == 0 ? "30s" : state + "m"))).component(), this.promiseExpiration.method_46426() + 3, this.promiseExpiration.method_46427() + 4, -1118482, true);
        class_1799 asStack = PackageStyles.getDefaultBox();
        int itemX = x + 68;
        int itemY = y + this.windowHeight - 24;
        graphics.method_51427(asStack, itemX, itemY);
        int promised = this.behaviour.getPromised();
        graphics.method_51432(this.field_22793, asStack, itemX, itemY, "" + promised);
        if (mouseX >= itemX && mouseX < itemX + 16 && mouseY >= itemY && mouseY < itemY + 16) {
            List<class_5250> promiseTip = promised == 0 ? List.of(CreateLang.translate("gui.factory_panel.no_open_promises", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate(this.restocker ? "gui.factory_panel.restocker_promises_tip" : "gui.factory_panel.recipe_promises_tip", new Object[0]).style(class_124.field_1080).component(), CreateLang.translate(this.restocker ? "gui.factory_panel.restocker_promises_tip_1" : "gui.factory_panel.recipe_promises_tip_1", new Object[0]).style(class_124.field_1080).component(), CreateLang.translate("gui.factory_panel.promise_prevents_oversending", new Object[0]).style(class_124.field_1080).component()) : List.of(CreateLang.translate("gui.factory_panel.promised_items", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.text(this.behaviour.getFilter().method_7964().getString() + " x" + promised).component(), CreateLang.translate("gui.factory_panel.left_click_reset", new Object[0]).style(class_124.field_1063).style(class_124.field_1056).component());
            graphics.method_51434(this.field_22793, promiseTip, mouseX, mouseY);
        }
        ms.popMatrix();
    }

    private void renderInputItem(class_332 graphics, int slot, BigItemStack itemStack, int mouseX, int mouseY) {
        int inputX = this.guiLeft + (this.restocker ? 88 : 68 + slot % 3 * 20);
        int inputY = this.guiTop + (this.restocker ? 12 : 28) + slot / 3 * 20;
        graphics.method_51427(itemStack.stack, inputX, inputY);
        if (!(this.craftingActive || this.restocker || itemStack.stack.method_7960())) {
            graphics.method_51432(this.field_22793, itemStack.stack, inputX, inputY, "" + itemStack.count);
        }
        if (mouseX < inputX - 2 || mouseX >= inputX - 2 + 20 || mouseY < inputY - 2 || mouseY >= inputY - 2 + 20) {
            return;
        }
        if (this.craftingActive) {
            graphics.method_51434(this.field_22793, List.of(CreateLang.translate("gui.factory_panel.crafting_input", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.factory_panel.crafting_input_tip", new Object[0]).style(class_124.field_1080).component(), CreateLang.translate("gui.factory_panel.crafting_input_tip_1", new Object[0]).style(class_124.field_1080).component()), mouseX, mouseY);
            return;
        }
        if (itemStack.stack.method_7960()) {
            graphics.method_51434(this.field_22793, List.of(CreateLang.translate("gui.factory_panel.empty_panel", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.factory_panel.left_click_disconnect", new Object[0]).style(class_124.field_1063).style(class_124.field_1056).component()), mouseX, mouseY);
            return;
        }
        if (this.restocker) {
            graphics.method_51434(this.field_22793, List.of(CreateLang.translate("gui.factory_panel.sending_item", CreateLang.itemName(itemStack.stack).string()).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.factory_panel.sending_item_tip", new Object[0]).style(class_124.field_1080).component(), CreateLang.translate("gui.factory_panel.sending_item_tip_1", new Object[0]).style(class_124.field_1080).component()), mouseX, mouseY);
            return;
        }
        graphics.method_51434(this.field_22793, List.of(CreateLang.translate("gui.factory_panel.sending_item", CreateLang.itemName(itemStack.stack).add(CreateLang.text(" x" + itemStack.count)).string()).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.factory_panel.scroll_to_change_amount", new Object[0]).style(class_124.field_1063).style(class_124.field_1056).component(), CreateLang.translate("gui.factory_panel.left_click_disconnect", new Object[0]).style(class_124.field_1063).style(class_124.field_1056).component()), mouseX, mouseY);
    }

    private void showAddressBoxTooltip(class_332 graphics, int mouseX, int mouseY) {
        if (this.addressBox.method_1882().isBlank()) {
            if (this.restocker) {
                graphics.method_51434(this.field_22793, List.of(CreateLang.translate("gui.factory_panel.restocker_address", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.factory_panel.restocker_address_tip", new Object[0]).style(class_124.field_1080).component(), CreateLang.translate("gui.factory_panel.restocker_address_tip_1", new Object[0]).style(class_124.field_1080).component(), CreateLang.translate("gui.schedule.lmb_edit", new Object[0]).style(class_124.field_1063).style(class_124.field_1056).component()), mouseX, mouseY);
            } else {
                graphics.method_51434(this.field_22793, List.of(CreateLang.translate("gui.factory_panel.recipe_address", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.factory_panel.recipe_address_tip", new Object[0]).style(class_124.field_1080).component(), CreateLang.translate("gui.factory_panel.recipe_address_tip_1", new Object[0]).style(class_124.field_1080).component(), CreateLang.translate("gui.schedule.lmb_edit", new Object[0]).style(class_124.field_1063).style(class_124.field_1056).component()), mouseX, mouseY);
            }
        } else {
            graphics.method_51434(this.field_22793, List.of(CreateLang.translate(this.restocker ? "gui.factory_panel.restocker_address_given" : "gui.factory_panel.recipe_address_given", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.text("'" + this.addressBox.method_1882() + "'").style(class_124.field_1080).component()), mouseX, mouseY);
        }
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        if (this.method_25399() != null && !this.method_25399().method_25405(mouseX, mouseY)) {
            this.method_25395(null);
        }
        int x = this.guiLeft;
        int y = this.guiTop;
        if (!this.craftingActive) {
            for (int i = 0; i < this.connections.size(); ++i) {
                int inputX = x + 68 + i % 3 * 20;
                int inputY = y + 28 + i / 3 * 20;
                if (!(mouseX >= (double)inputX) || !(mouseX < (double)(inputX + 16)) || !(mouseY >= (double)inputY) || !(mouseY < (double)(inputY + 16))) continue;
                this.sendIt(this.connections.get((int)i).from, false);
                this.playButtonSound();
                return true;
            }
        }
        int itemX = x + 68;
        int itemY = y + this.windowHeight - 24;
        if (mouseX >= (double)itemX && mouseX < (double)(itemX + 16) && mouseY >= (double)itemY && mouseY < (double)(itemY + 16)) {
            this.sendIt(null, true);
            this.playButtonSound();
            return true;
        }
        itemX = x + 9;
        itemY = y + this.windowHeight - 24;
        if (mouseX >= (double)itemX && mouseX < (double)(itemX + 16) && mouseY >= (double)itemY && mouseY < (double)(itemY + 16)) {
            this.sendRedstoneReset = true;
            this.sendIt(null, false);
            this.playButtonSound();
            return true;
        }
        return super.method_25402(click, doubled);
    }

    public void playButtonSound() {
        this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_15015.comp_349()), (float)1.0f, (float)0.25f));
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        int x = this.guiLeft;
        int y = this.guiTop;
        if (this.addressBox.method_25401(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        if (this.craftingActive) {
            return super.method_25401(mouseX, mouseY, scrollX, scrollY);
        }
        for (int i = 0; i < this.inputConfig.size(); ++i) {
            int inputX = x + 68 + i % 3 * 20;
            int inputY = y + 26 + i / 3 * 20;
            if (!(mouseX >= (double)inputX) || !(mouseX < (double)(inputX + 16)) || !(mouseY >= (double)inputY) || !(mouseY < (double)(inputY + 16))) continue;
            BigItemStack itemStack = this.inputConfig.get(i);
            if (itemStack.stack.method_7960()) {
                return true;
            }
            itemStack.count = class_3532.method_15340((int)((int)((double)itemStack.count + Math.signum(scrollY) * (double)(AllKeys.hasShiftDown() ? 10 : 1))), (int)1, (int)64);
            return true;
        }
        if (!this.restocker) {
            int outputX = x + 160;
            int outputY = y + 48;
            if (mouseX >= (double)outputX && mouseX < (double)(outputX + 16) && mouseY >= (double)outputY && mouseY < (double)(outputY + 16)) {
                BigItemStack itemStack = this.outputConfig;
                itemStack.count = class_3532.method_15340((int)((int)((double)itemStack.count + Math.signum(scrollY) * (double)(AllKeys.hasShiftDown() ? 10 : 1))), (int)1, (int)64);
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public void method_25432() {
        this.sendIt(null, false);
        this.clearRenderedElements();
    }

    private void sendIt(@Nullable FactoryPanelPosition toRemove, boolean clearPromises) {
        HashMap<FactoryPanelPosition, Integer> inputs = new HashMap<FactoryPanelPosition, Integer>();
        if (this.inputConfig.size() == this.connections.size()) {
            for (int i = 0; i < this.inputConfig.size(); ++i) {
                BigItemStack stackInConfig = this.inputConfig.get(i);
                inputs.put(this.connections.get((int)i).from, this.craftingActive ? (int)this.behaviour.craftingList.stream().skip(1L).filter(b -> !b.stack.method_7960() && class_1799.method_31577((class_1799)b.stack, (class_1799)stackInConfig.stack)).count() : stackInConfig.count);
            }
        }
        List<class_1799> craftingArrangement = this.craftingActive ? this.behaviour.craftingList.stream().skip(1L).map(b -> b.stack).toList() : List.of();
        FactoryPanelPosition pos = this.behaviour.getPanelPosition();
        int promiseExp = this.promiseExpiration.getState();
        String address = this.addressBox.method_1882();
        FactoryPanelConfigurationPacket packet = new FactoryPanelConfigurationPacket(pos, address, inputs, craftingArrangement, this.outputConfig.count, promiseExp, toRemove, clearPromises, this.sendReset, this.sendRedstoneReset);
        this.field_22787.field_1724.field_3944.method_52787((class_2596)packet);
    }
}

